
#ifndef SST_TST_ATP_ROLLBACK_H
#define SST_TST_ATP_ROLLBACK_H
#if TST_USE_ROLL_BACK_MODULE
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_RollBack.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_RollBack         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the capability of transaction rollback while inserting, deleting and modifying objects
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionEnd.
 *    5.  Open the password authenticator by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Insert a new data objects 1~4 (type: simple data) by calling: SST_InsertData.
 *    8.    Create a new iterator by calling: SST_TypeIteratorBegin. With the simple data handle 
 *    9.    Get all handles and verify all are correct and exist
 *          a. Verify all handles returned are correct
 *          b. Verify numbers of handles returned
 *          c. Check that all handles returned are valid
 *    10.   Delete Iterator by calling: SST_TypeIteratorTerminate
 *    11.   Close the transaction by calling: SST_TransactionEnd.
 *    12.   Open a transaction by calling: SST_TransactionStart. 
 *    13.   Insert a new Data objects 1~2 as additional data by calling: SST_InsertData.
 *    14.   Roll back the modification of the data by calling: SST_TransactionRollback 
 *    15.   Create a new iterator by calling: SST_TypeIteratorBegin. With the simple data handle 
 *    16.   Get all handles and verify all are correct and exist
 *          a. Verify all handles returned are correct
 *          b. Verify numbers of handles returned
 *          c. Check that all handles returned are valid
 *    17.   Open a transaction by calling: SST_TransactionStart.
 *    18.   Get Data to temp buffer before modification
 *    19.   Modify the data from selected location by calling: SST_DataModify
 *    20.   Roll back the modification of the data by calling: SST_TransactionRollback 
 *    21.   Retrieve the data and verify it was not modified
 *    22.   Open a transaction by calling: SST_TransactionStart
 *    23.   Delete all the data objects (one by one) by calling: SST_DataDelete. 
 *    24.   Roll back the modification of the data by calling: SST_TransactionRollback 
 *    25.   Create a new iterator by calling: SST_TypeIteratorBegin. With the simple data handle 
 *    26.   Get all handles and verify all are correct and exist
 *          a. Verify all handles returned are correct
 *          b. Verify numbers of handles returned
 *          c. Check that all handles returned are valid
 *    27.   Open a transaction by calling: SST_TransactionStart
 *    28.   Delete the iterator by calling: SST_TypeIteratorTerminate.
 *    29.   Delete all the data objects (one by one) by calling: SST_DataDelete.
 *    30.   Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    31.   Close the transaction by calling: SST_TransactionEnd.
 *    32.   Delete the session by calling: SST_SessionDelete.
 *
 * Comment:
 *    This test uses the Iterator test data and structures
 *
 *******************************************************************************/     
DxError_t SST_TST_ATP_RollBack ( void );


#ifdef __cplusplus
}
#endif

#endif

#endif

